#version 330 core

precision highp float;

//0
//layout (points) in; // typ wejciowy
//layout (points, max_vertices = 1) out; // typ wyjciowy

//1
//layout (points) in; // typ wejciowy
//layout (triangle_strip, max_vertices = 5) out; // typ wyjciowy

//2-0
//layout (lines_adjacency) in; // typ wejciowy
//layout (line_strip, max_vertices = 4) out; // typ wyjciowy

//2-1
layout (lines_adjacency) in; // typ wejciowy
layout (line_strip, max_vertices = 30) out; // typ wyjciowy, liczba = num nizej


in VertexData
{
	//vec4 position;
	vec4 color;
} vertex[];

out vec4 color;

void main(void)
{
	/*
	for (int i = 0; i < gl_in.length() ; ++i)
	{
		color = vertex[i].color;
		gl_Position = gl_in[i].gl_Position * 10.0;
		
		EmitVertex();
	}
	*/

	/*
	//1
	color=gl_in[0].gl_Position;
	gl_Position=gl_in[0].gl_Position+vec4(-0.1,0.1,0.0,0.0); EmitVertex(); //przesuniecie werteksu
	gl_Position=gl_in[0].gl_Position+vec4(0.1,0.1,0.0,0.0); EmitVertex();
	gl_Position=gl_in[0].gl_Position+vec4(-0.1,-0.1,0.0,0.0); EmitVertex();
	gl_Position=gl_in[0].gl_Position+vec4(-0.2,-0.2,0.0,0.0); EmitVertex();
	//Uzycie EmitVertex powoduje wyslanie "sklonowanego" werteksu
	//Nieuzycie zadnego EmitVertex spowoduje "zjedzenie" werteksu
	//poniewaz uzylismy wyjsciowego layoutu trojkata - powstaja z jednego werteksu trojkaty
	*/

	/*
	//2-0	
	color=gl_in[0].gl_Position;
	for(int i=0;i<gl_in.length();i++)
	{
		gl_Position=gl_in[i].gl_Position;
		color=gl_in[i].gl_Position;
		EmitVertex();
	}
	*/

	//2-1
	//Krzywa Beziere wygladzajaca linie
	color=gl_in[0].gl_Position;
	int num=30;
	float dt=1./float(num);
	float t=0;
	for(int i=0;i<num;i++)
	{
		float omt=1.-t;
		float omt2=omt*omt;
		float omt3=omt*omt2;
		float t2=t*t;
		float t3=t*t2;
		vec4 xyzw=
			omt3*gl_in[0].gl_Position.xyzw+
			3*t*omt2*gl_in[1].gl_Position.xyzw+
			3*t2*omt*gl_in[2].gl_Position.xyzw+
			t3*gl_in[3].gl_Position.xyzw;
		gl_Position=xyzw;
		EmitVertex();
		t+=dt;
	}
	

	EndPrimitive();
}